# Intuition
<!-- Describe your first thoughts on how to solve this problrm --> Can be solved by sorting.

# Approach
<!-- Describe your approach to solving the problem. -->
Basically check whether larger power batteries are greater than average or not, find limiting batteries ( same like the limiting reagent in chemistry )

- Store sum of all elements of the array
- Now, after sorting larger power batteries will be on last, so iterate from last and check if that battery power is greater than average ( total battery power / number of computers )
- - if yes then it will not get fully drained : so keep them aside and update the variables of iteration
- - if no then it means that even larger power batteries are below average, so they will be fully used - they and batteries smaller than them

Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)


# Complexity
- Time complexity : $$O(nlogn)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->
It's the time complexity of Arrays.sort()

- Space complexity : $$O(1)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public long maxRunTime(int n, int[] batteries) {
         long t = Arrays.stream( batteries).asLongStream().sum();   // it returns the sum of all elements of the array
        Arrays.sort( batteries);
        // Now, after sorting larger power batteries will be on last, so iterate from last and check if that battery power is greater than average ( total battery power / number of computers )
            // if yes then it will not get fully drained : so keep them aside and update the variables of iteration
        int i = batteries.length - 1;   
        while( batteries[i] > t / n){
            t -= batteries[i--];       // it means batteries[i] is getting subtracted from t and after that i is decrementing by 1
            n--;
        }
            // if no then it means that even larger power batteries are below average, so they will be fully used - they and batteries smaller than them
        return t / n;
    }
}
```